	function [k, c] = GRAY_MARKEL_N(G, Z, P)
	
	%	Computes the coefficients for the normalized 
	%	Gray and Markel structure. Power waves.
	%
	%	k contains the reflection coefficient and c the  taps.
	%	The L2-norms to the inputs and outputs to the 
	%	two-ports are all = 1.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2011-02-11
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	[k, c, alfa] = GRAY_MARKEL_2(G, Z, P);
	N = length(P);
	p(N+1) = 1;
	for m = N:-1:1
		p(m) = p(m+1)*sqrt(1 - k(m)^2);
	end
	c = c./p';
